<?php

namespace App\Http\Controllers;

use App\Models\User;
// use App\Models\Tutor;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class AdminController extends Controller
{
    public function dashboard() {
        // Users Statistics
        $data['totalUsers'] =  User::withoutRole('super_admin')->withTrashed()->count();
        $data['activeUsers'] = User::withoutRole('super_admin')->count();
        $data['inActiveUsers'] = $data['totalUsers'] - $data['activeUsers'];

        // Donations Statistics
        // $data['totalDonationRequests'] = Tutor::count();
        // $data['totalTutor'] = User::withoutRole('super_admin')->where('is_tutor', 1)->count();
        // $data['totalDonations'] = DB::table('accepted_requests')->where('donated', 1)->count();

        return view('dashboard')->with($data);
    }

    public function users() {
        $users = User::withoutRole('super_admin')->withTrashed()->orderBy('name')->paginate(20);
        return view('admin.users.index', compact('users'));
    }

    public function toggleUserDeletion(Request $request) {
        $validData = $request->validate([
            'user_id' => ['required', 'integer'],
        ]);

        $user = User::withTrashed()->findOrFail($validData['user_id']);
        if($user->trashed()) {
            $user->restore();
        }
        else {
            $user->delete();
        }

        return back()->withSuccess('User account has been updated');
    }
}
